/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.php.formatter;

import com.aptana.editor.php.formatter.PHPFormatterNodeBuilder;
import com.aptana.editor.php.formatter.nodes.FormatterPHPArrayElementNode;
import com.aptana.editor.php.formatter.nodes.FormatterPHPBlockNode;
import com.aptana.editor.php.formatter.nodes.FormatterPHPBreakNode;
import com.aptana.editor.php.formatter.nodes.FormatterPHPCaseBodyNode;
import com.aptana.editor.php.formatter.nodes.FormatterPHPCaseColonNode;
import com.aptana.editor.php.formatter.nodes.FormatterPHPDeclarationNode;
import com.aptana.editor.php.formatter.nodes.FormatterPHPElseIfNode;
import com.aptana.editor.php.formatter.nodes.FormatterPHPElseNode;
import com.aptana.editor.php.formatter.nodes.FormatterPHPExcludedTextNode;
import com.aptana.editor.php.formatter.nodes.FormatterPHPExpressionWrapperNode;
import com.aptana.editor.php.formatter.nodes.FormatterPHPFunctionBodyNode;
import com.aptana.editor.php.formatter.nodes.FormatterPHPFunctionInvocationNode;
import com.aptana.editor.php.formatter.nodes.FormatterPHPHeredocNode;
import com.aptana.editor.php.formatter.nodes.FormatterPHPIfNode;
import com.aptana.editor.php.formatter.nodes.FormatterPHPImplicitBlockNode;
import com.aptana.editor.php.formatter.nodes.FormatterPHPKeywordNode;
import com.aptana.editor.php.formatter.nodes.FormatterPHPLineStartingNode;
import com.aptana.editor.php.formatter.nodes.FormatterPHPNamespaceBlockNode;
import com.aptana.editor.php.formatter.nodes.FormatterPHPNonBlockedWhileNode;
import com.aptana.editor.php.formatter.nodes.FormatterPHPOperatorNode;
import com.aptana.editor.php.formatter.nodes.FormatterPHPParenthesesNode;
import com.aptana.editor.php.formatter.nodes.FormatterPHPPunctuationNode;
import com.aptana.editor.php.formatter.nodes.FormatterPHPSwitchNode;
import com.aptana.editor.php.formatter.nodes.FormatterPHPTextNode;
import com.aptana.editor.php.formatter.nodes.FormatterPHPTraitPrecedenceWrapperNode;
import com.aptana.editor.php.formatter.nodes.FormatterPHPTypeBodyNode;
import com.aptana.editor.php.internal.indexer.PHPDocUtils;
import com.aptana.formatter.FormatterDocument;
import com.aptana.formatter.FormatterUtils;
import com.aptana.formatter.IFormatterDocument;
import com.aptana.formatter.nodes.AbstractFormatterNodeBuilder;
import com.aptana.formatter.nodes.IFormatterContainerNode;
import com.aptana.formatter.nodes.IFormatterNode;
import com.aptana.formatter.nodes.NodeTypes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jface.text.IRegion;
import org2.eclipse.php.core.compiler.PHPFlags;
import org2.eclipse.php.internal.core.ast.nodes.ASTError;
import org2.eclipse.php.internal.core.ast.nodes.ASTNode;
import org2.eclipse.php.internal.core.ast.nodes.ArrayAccess;
import org2.eclipse.php.internal.core.ast.nodes.ArrayCreation;
import org2.eclipse.php.internal.core.ast.nodes.ArrayElement;
import org2.eclipse.php.internal.core.ast.nodes.Assignment;
import org2.eclipse.php.internal.core.ast.nodes.BackTickExpression;
import org2.eclipse.php.internal.core.ast.nodes.Block;
import org2.eclipse.php.internal.core.ast.nodes.BreakStatement;
import org2.eclipse.php.internal.core.ast.nodes.CastExpression;
import org2.eclipse.php.internal.core.ast.nodes.CatchClause;
import org2.eclipse.php.internal.core.ast.nodes.ChainingInstanceCall;
import org2.eclipse.php.internal.core.ast.nodes.ClassDeclaration;
import org2.eclipse.php.internal.core.ast.nodes.ClassInstanceCreation;
import org2.eclipse.php.internal.core.ast.nodes.ClassName;
import org2.eclipse.php.internal.core.ast.nodes.CloneExpression;
import org2.eclipse.php.internal.core.ast.nodes.Comment;
import org2.eclipse.php.internal.core.ast.nodes.ConditionalExpression;
import org2.eclipse.php.internal.core.ast.nodes.ConstantDeclaration;
import org2.eclipse.php.internal.core.ast.nodes.ContinueStatement;
import org2.eclipse.php.internal.core.ast.nodes.DeclareStatement;
import org2.eclipse.php.internal.core.ast.nodes.DereferenceNode;
import org2.eclipse.php.internal.core.ast.nodes.DoStatement;
import org2.eclipse.php.internal.core.ast.nodes.EchoStatement;
import org2.eclipse.php.internal.core.ast.nodes.EmptyStatement;
import org2.eclipse.php.internal.core.ast.nodes.Expression;
import org2.eclipse.php.internal.core.ast.nodes.ExpressionStatement;
import org2.eclipse.php.internal.core.ast.nodes.FieldAccess;
import org2.eclipse.php.internal.core.ast.nodes.FieldsDeclaration;
import org2.eclipse.php.internal.core.ast.nodes.ForEachStatement;
import org2.eclipse.php.internal.core.ast.nodes.ForStatement;
import org2.eclipse.php.internal.core.ast.nodes.FormalParameter;
import org2.eclipse.php.internal.core.ast.nodes.FullyQualifiedTraitMethodReference;
import org2.eclipse.php.internal.core.ast.nodes.FunctionDeclaration;
import org2.eclipse.php.internal.core.ast.nodes.FunctionInvocation;
import org2.eclipse.php.internal.core.ast.nodes.FunctionName;
import org2.eclipse.php.internal.core.ast.nodes.GlobalStatement;
import org2.eclipse.php.internal.core.ast.nodes.GotoLabel;
import org2.eclipse.php.internal.core.ast.nodes.GotoStatement;
import org2.eclipse.php.internal.core.ast.nodes.Identifier;
import org2.eclipse.php.internal.core.ast.nodes.IfStatement;
import org2.eclipse.php.internal.core.ast.nodes.IgnoreError;
import org2.eclipse.php.internal.core.ast.nodes.InLineHtml;
import org2.eclipse.php.internal.core.ast.nodes.Include;
import org2.eclipse.php.internal.core.ast.nodes.InfixExpression;
import org2.eclipse.php.internal.core.ast.nodes.InstanceOfExpression;
import org2.eclipse.php.internal.core.ast.nodes.InterfaceDeclaration;
import org2.eclipse.php.internal.core.ast.nodes.LambdaFunctionDeclaration;
import org2.eclipse.php.internal.core.ast.nodes.ListVariable;
import org2.eclipse.php.internal.core.ast.nodes.MethodDeclaration;
import org2.eclipse.php.internal.core.ast.nodes.MethodInvocation;
import org2.eclipse.php.internal.core.ast.nodes.NamespaceDeclaration;
import org2.eclipse.php.internal.core.ast.nodes.NamespaceName;
import org2.eclipse.php.internal.core.ast.nodes.PHPArrayDereferenceList;
import org2.eclipse.php.internal.core.ast.nodes.ParenthesisExpression;
import org2.eclipse.php.internal.core.ast.nodes.PostfixExpression;
import org2.eclipse.php.internal.core.ast.nodes.PrefixExpression;
import org2.eclipse.php.internal.core.ast.nodes.Quote;
import org2.eclipse.php.internal.core.ast.nodes.Reference;
import org2.eclipse.php.internal.core.ast.nodes.ReflectionVariable;
import org2.eclipse.php.internal.core.ast.nodes.ReturnStatement;
import org2.eclipse.php.internal.core.ast.nodes.Scalar;
import org2.eclipse.php.internal.core.ast.nodes.Statement;
import org2.eclipse.php.internal.core.ast.nodes.StaticConstantAccess;
import org2.eclipse.php.internal.core.ast.nodes.StaticFieldAccess;
import org2.eclipse.php.internal.core.ast.nodes.StaticMethodInvocation;
import org2.eclipse.php.internal.core.ast.nodes.StaticStatement;
import org2.eclipse.php.internal.core.ast.nodes.SwitchCase;
import org2.eclipse.php.internal.core.ast.nodes.SwitchStatement;
import org2.eclipse.php.internal.core.ast.nodes.ThrowStatement;
import org2.eclipse.php.internal.core.ast.nodes.TraitAlias;
import org2.eclipse.php.internal.core.ast.nodes.TraitDeclaration;
import org2.eclipse.php.internal.core.ast.nodes.TraitPrecedence;
import org2.eclipse.php.internal.core.ast.nodes.TraitStatement;
import org2.eclipse.php.internal.core.ast.nodes.TraitUseStatement;
import org2.eclipse.php.internal.core.ast.nodes.TryStatement;
import org2.eclipse.php.internal.core.ast.nodes.TypeDeclaration;
import org2.eclipse.php.internal.core.ast.nodes.UnaryOperation;
import org2.eclipse.php.internal.core.ast.nodes.UseStatement;
import org2.eclipse.php.internal.core.ast.nodes.UseStatementPart;
import org2.eclipse.php.internal.core.ast.nodes.Variable;
import org2.eclipse.php.internal.core.ast.nodes.VariableBase;
import org2.eclipse.php.internal.core.ast.nodes.WhileStatement;
import org2.eclipse.php.internal.core.ast.visitor.AbstractVisitor;
import org2.eclipse.php.internal.core.ast.visitor.Visitor;

public class PHPFormatterVisitor
extends AbstractVisitor {
    private static final Pattern WORD_PATTERN = Pattern.compile("\\w+");
    private static final Pattern LINE_SPLIT_PATTERN = Pattern.compile("\r?\n|\r");
    public static final String INVOCATION_ARROW = "->";
    public static final String STATIC_INVOCATION = "::";
    private static final char[] SEMICOLON_AND_COLON = new char[]{';', ','};
    private static final char[] SEMICOLON = new char[]{';'};
    private FormatterDocument document;
    private PHPFormatterNodeBuilder builder;
    private Set<Integer> multiLinecommentsEndOffsets;
    private Set<Integer> singleLinecommentsEndOffsets;
    private List<IRegion> onOffRegions;
    private List<Comment> comments;

    public PHPFormatterVisitor(FormatterDocument document, PHPFormatterNodeBuilder builder, List<Comment> comments) {
        this.document = document;
        this.builder = builder;
        this.processComments(comments);
    }

    private void processComments(List<Comment> comments) {
        this.comments = comments;
        this.multiLinecommentsEndOffsets = new HashSet<Integer>();
        this.singleLinecommentsEndOffsets = new HashSet<Integer>();
        if (comments == null) {
            return;
        }
        boolean onOffEnabled = this.document.getBoolean("php.formatter.formatter.on.off.enabled");
        LinkedHashMap<Integer, String> commentsMap = onOffEnabled ? new LinkedHashMap<Integer, String>(comments.size()) : null;
        for (Comment comment : comments) {
            int commentType = comment.getCommentType();
            int end = comment.getEnd();
            if (commentType == 0) {
                this.singleLinecommentsEndOffsets.add(this.builder.getNextNonWhiteCharOffset(this.document, end));
            } else if (commentType == 1 || commentType == 2) {
                this.multiLinecommentsEndOffsets.add(this.builder.getNextNonWhiteCharOffset(this.document, end));
            }
            if (!onOffEnabled) continue;
            int start = comment.getStart();
            String commentStr = this.document.get(start, end);
            commentsMap.put(start, commentStr);
        }
        if (onOffEnabled && !commentsMap.isEmpty()) {
            Pattern onPattern = Pattern.compile(Pattern.quote(this.document.getString("php.formatter.formatter.on")));
            Pattern offPattern = Pattern.compile(Pattern.quote(this.document.getString("php.formatter.formatter.off")));
            this.onOffRegions = FormatterUtils.resolveOnOffRegions(commentsMap, (Pattern)onPattern, (Pattern)offPattern, (int)(this.document.getLength() - 1));
        }
    }

    public List<IRegion> getOnOffRegions() {
        return this.onOffRegions;
    }

    private boolean hasAnyCommentBefore(int offset) {
        return this.multiLinecommentsEndOffsets.contains(offset) || this.singleLinecommentsEndOffsets.contains(offset);
    }

    private boolean hasMultiLineCommentBefore(int offset) {
        return this.multiLinecommentsEndOffsets.contains(offset);
    }

    private boolean hasSingleLineCommentBefore(int offset) {
        return this.singleLinecommentsEndOffsets.contains(offset);
    }

    public boolean visit(IfStatement ifStatement) {
        Statement falseStatement = ifStatement.getFalseStatement();
        Statement trueStatement = ifStatement.getTrueStatement();
        boolean isEmptyFalseBlock = falseStatement == null;
        boolean hasTrueBlock = trueStatement.getType() == 6;
        boolean hasFalseBlock = !isEmptyFalseBlock && falseStatement.getType() == 6;
        int start = ifStatement.getStart();
        FormatterPHPIfNode conditionNode = new FormatterPHPIfNode((IFormatterDocument)this.document, hasTrueBlock, (ASTNode)ifStatement);
        int startLength = this.document.charAt(start) == 'e' ? 6 : 2;
        conditionNode.setBegin(AbstractFormatterNodeBuilder.createTextNode((IFormatterDocument)this.document, (int)start, (int)(start + startLength)));
        this.builder.push((IFormatterContainerNode)conditionNode);
        this.pushNodeInParentheses('(', ')', start + startLength, trueStatement.getStart(), (ASTNode)ifStatement.getCondition(), NodeTypes.TypeBracket.CONDITIONAL_PARENTHESIS);
        if (hasTrueBlock) {
            this.visitBlockNode((Block)trueStatement, (ASTNode)ifStatement, isEmptyFalseBlock);
        } else {
            this.wrapInImplicitBlock((ASTNode)trueStatement, false);
        }
        this.builder.checkedPop((IFormatterContainerNode)conditionNode, trueStatement.getEnd());
        if (!isEmptyFalseBlock) {
            int falseBlockStart;
            int trueBlockEnd = trueStatement.getEnd();
            String segment = trueBlockEnd != (falseBlockStart = falseStatement.getStart()) ? this.document.get(trueBlockEnd, falseBlockStart) : "";
            int elsePos = segment.toLowerCase().indexOf("else");
            boolean isElseIf = falseStatement.getType() == 34;
            boolean isConnectedElsif = isElseIf && elsePos < 0;
            FormatterPHPElseNode elseNode = null;
            if (!isConnectedElsif) {
                int elseBlockStart = elsePos + trueBlockEnd;
                int elseBlockDeclarationEnd = elseBlockStart + 4;
                elseNode = new FormatterPHPElseNode((IFormatterDocument)this.document, hasFalseBlock, isElseIf, hasTrueBlock, this.hasAnyCommentBefore(elseBlockStart));
                elseNode.setBegin(AbstractFormatterNodeBuilder.createTextNode((IFormatterDocument)this.document, (int)elseBlockStart, (int)elseBlockDeclarationEnd));
                this.builder.push((IFormatterContainerNode)elseNode);
            }
            if (!isConnectedElsif && hasFalseBlock) {
                this.visitBlockNode((Block)falseStatement, (ASTNode)ifStatement, true);
            } else if (isElseIf) {
                FormatterPHPElseIfNode elseIfNode = new FormatterPHPElseIfNode((IFormatterDocument)this.document, this.hasAnyCommentBefore(falseBlockStart));
                elseIfNode.setBegin(AbstractFormatterNodeBuilder.createTextNode((IFormatterDocument)this.document, (int)falseBlockStart, (int)falseBlockStart));
                this.builder.push((IFormatterContainerNode)elseIfNode);
                falseStatement.accept((Visitor)this);
                int falseBlockEnd = falseStatement.getEnd();
                this.builder.checkedPop((IFormatterContainerNode)elseIfNode, falseBlockEnd);
                int end = elseIfNode.getEndOffset();
                elseIfNode.setEnd(AbstractFormatterNodeBuilder.createTextNode((IFormatterDocument)this.document, (int)end, (int)end));
            } else {
                this.wrapInImplicitBlock((ASTNode)falseStatement, false);
            }
            if (elseNode != null) {
                this.builder.checkedPop((IFormatterContainerNode)elseNode, falseStatement.getEnd());
            }
        }
        return false;
    }

    public boolean visit(ArrayAccess arrayAccess) {
        Expression index = arrayAccess.getIndex();
        VariableBase name = arrayAccess.getName();
        name.accept((Visitor)this);
        if (arrayAccess.getArrayType() == 2) {
            this.pushNodeInParentheses('{', '}', name.getEnd(), arrayAccess.getEnd(), (ASTNode)index, NodeTypes.TypeBracket.ARRAY_CURLY);
        } else {
            this.pushNodeInParentheses('[', ']', name.getEnd(), arrayAccess.getEnd(), (ASTNode)index, NodeTypes.TypeBracket.ARRAY_SQUARE);
        }
        return false;
    }

    public boolean visit(ArrayCreation arrayCreation) {
        boolean isShortSyntax = !arrayCreation.isHasArrayKey();
        int declarationEndOffset = arrayCreation.getStart();
        if (!isShortSyntax) {
            this.visitCommonDeclaration((ASTNode)arrayCreation, declarationEndOffset += 5, true);
        }
        List elements = arrayCreation.elements();
        NodeTypes.TypeBracket bracketType = isShortSyntax ? NodeTypes.TypeBracket.ARRAY_SQUARE : NodeTypes.TypeBracket.ARRAY_PARENTHESIS;
        this.pushParametersInParentheses(declarationEndOffset, arrayCreation.getEnd(), elements, NodeTypes.TypePunctuation.ARRAY_COMMA, true, bracketType, false);
        return false;
    }

    public boolean visit(ArrayElement arrayElement) {
        Expression key = arrayElement.getKey();
        Expression value = arrayElement.getValue();
        ArrayList<Expression> leftNodes = new ArrayList<Expression>(1);
        ArrayList<Expression> rightNodes = null;
        if (key == null) {
            leftNodes.add(value);
        } else {
            leftNodes.add(key);
            rightNodes = new ArrayList<Expression>(1);
            rightNodes.add(value);
        }
        ArrayCreation parent = (ArrayCreation)arrayElement.getParent();
        boolean hasSingleElement = parent.elements().size() == 1;
        FormatterPHPArrayElementNode arrayElementNode = new FormatterPHPArrayElementNode((IFormatterDocument)this.document, hasSingleElement, this.hasAnyCommentBefore(arrayElement.getStart()));
        arrayElementNode.setBegin(AbstractFormatterNodeBuilder.createTextNode((IFormatterDocument)this.document, (int)arrayElement.getStart(), (int)arrayElement.getStart()));
        this.builder.push((IFormatterContainerNode)arrayElementNode);
        this.visitNodeLists(leftNodes, rightNodes, NodeTypes.TypeOperator.KEY_VALUE, null);
        arrayElementNode.setEnd(AbstractFormatterNodeBuilder.createTextNode((IFormatterDocument)this.document, (int)arrayElement.getEnd(), (int)arrayElement.getEnd()));
        this.builder.checkedPop((IFormatterContainerNode)arrayElementNode, -1);
        return false;
    }

    public boolean visit(Assignment assignment) {
        VariableBase leftHandSide = assignment.getLeftHandSide();
        Expression rightHandSide = assignment.getRightHandSide();
        String operationString = assignment.getOperationString();
        this.visitLeftRightExpression((ASTNode)assignment, (ASTNode)leftHandSide, (ASTNode)rightHandSide, operationString);
        return false;
    }

    public boolean visit(FormalParameter formalParameter) {
        Expression parameterName = formalParameter.getParameterName();
        Expression parameterType = formalParameter.getParameterType();
        if (parameterType != null) {
            if (parameterType.getType() == 33) {
                this.visit((Identifier)parameterType);
            } else if (parameterType.getType() == 65) {
                this.visit((NamespaceName)parameterType);
            }
            this.visitTextNode((ASTNode)parameterName, true, 1);
        } else {
            parameterName.accept((Visitor)this);
        }
        Expression defaultValue = formalParameter.getDefaultValue();
        if (defaultValue != null) {
            int assignmentOffset = this.builder.getNextNonWhiteCharOffset(this.document, parameterName.getEnd());
            this.pushTypeOperator(NodeTypes.TypeOperator.ASSIGNMENT, assignmentOffset, false);
            this.visitTextNode((ASTNode)defaultValue, true, 0);
        }
        return false;
    }

    public boolean visit(ASTError astError) {
        this.builder.setHasErrors(true);
        return false;
    }

    public boolean visit(BackTickExpression backTickExpression) {
        this.visitTextNode((ASTNode)backTickExpression, true, 0);
        return false;
    }

    public boolean visit(Block block) {
        FormatterPHPBlockNode blockNode = new FormatterPHPBlockNode((IFormatterDocument)this.document, block.getParent().getType() == 46);
        blockNode.setBegin(AbstractFormatterNodeBuilder.createTextNode((IFormatterDocument)this.document, (int)block.getStart(), (int)(block.getStart() + 1)));
        this.builder.push((IFormatterContainerNode)blockNode);
        block.childrenAccept((Visitor)this);
        int end = block.getEnd();
        this.builder.checkedPop((IFormatterContainerNode)blockNode, end - 1);
        if (block.isCurly()) {
            int endWithSemicolon = this.locateCharMatchInLine(end, SEMICOLON_AND_COLON, this.document, false);
            blockNode.setEnd(AbstractFormatterNodeBuilder.createTextNode((IFormatterDocument)this.document, (int)(end - 1), (int)endWithSemicolon));
        } else {
            blockNode.setEnd(AbstractFormatterNodeBuilder.createTextNode((IFormatterDocument)this.document, (int)end, (int)end));
        }
        return false;
    }

    public boolean visit(BreakStatement breakStatement) {
        Expression expression = breakStatement.getExpression();
        int start = breakStatement.getStart();
        int end = breakStatement.getEnd();
        if (expression == null) {
            FormatterPHPBreakNode breakNode = new FormatterPHPBreakNode((IFormatterDocument)this.document, breakStatement.getParent());
            breakNode.setBegin(AbstractFormatterNodeBuilder.createTextNode((IFormatterDocument)this.document, (int)start, (int)(start + 5)));
            this.builder.push((IFormatterContainerNode)breakNode);
            this.builder.checkedPop((IFormatterContainerNode)breakNode, -1);
        } else {
            this.pushKeyword(start, 5, true, false);
            expression.accept((Visitor)this);
        }
        this.findAndPushPunctuationNode(NodeTypes.TypePunctuation.SEMICOLON, end - 1, false, true);
        return false;
    }

    public boolean visit(ClassDeclaration classDeclaration) {
        this.visitTypeDeclaration((TypeDeclaration)classDeclaration);
        return false;
    }

    public boolean visit(ClassInstanceCreation classInstanceCreation) {
        ChainingInstanceCall chainingInstanceCall;
        ClassName className = classInstanceCreation.getClassName();
        int creationEnd = classInstanceCreation.getEnd();
        boolean hasParentheses = creationEnd != className.getEnd();
        int start = classInstanceCreation.getStart();
        this.visitTextNode(start, start + 3, true, 0);
        className.accept((Visitor)this);
        if (hasParentheses) {
            List ctorParams = classInstanceCreation.ctorParams();
            this.pushParametersInParentheses(className.getEnd(), classInstanceCreation.getEnd(), ctorParams, NodeTypes.TypePunctuation.COMMA, false, NodeTypes.TypeBracket.DECLARATION_PARENTHESIS, false);
        }
        if ((chainingInstanceCall = classInstanceCreation.getChainingInstanceCall()) != null) {
            chainingInstanceCall.accept((Visitor)this);
        }
        return false;
    }

    public boolean visit(ClassName className) {
        this.visitTextNode((ASTNode)className, true, 1);
        return false;
    }

    public boolean visit(CloneExpression cloneExpression) {
        int cloneStart = cloneExpression.getStart();
        this.pushFunctionInvocationName((ASTNode)cloneExpression, cloneStart, cloneStart + 5);
        ArrayList<Expression> expressionInList = new ArrayList<Expression>(1);
        expressionInList.add(cloneExpression.getExpression());
        this.pushParametersInParentheses(cloneStart + 5, cloneExpression.getEnd(), expressionInList, NodeTypes.TypePunctuation.COMMA, false, NodeTypes.TypeBracket.INVOCATION_PARENTHESIS, true);
        return false;
    }

    public boolean visit(ConditionalExpression conditionalExpression) {
        int endLookup;
        int startLookup;
        Expression condition = conditionalExpression.getCondition();
        condition.accept((Visitor)this);
        Expression ifTrue = conditionalExpression.getIfTrue();
        Expression ifFalse = conditionalExpression.getIfFalse();
        if (ifTrue != null) {
            startLookup = ifTrue.getStart();
            endLookup = ifTrue.getEnd();
        } else {
            startLookup = ifFalse.getStart();
            endLookup = condition.getEnd();
        }
        int conditionalOpOffset = condition.getEnd() + this.document.get(condition.getEnd(), startLookup).indexOf(63);
        this.pushTypeOperator(NodeTypes.TypeOperator.CONDITIONAL, conditionalOpOffset, false);
        if (ifTrue != null) {
            ifTrue.accept((Visitor)this);
        }
        int colonOffset = endLookup + this.document.get(endLookup, ifFalse.getStart()).indexOf(58);
        this.pushTypeOperator(NodeTypes.TypeOperator.CONDITIONAL_COLON, colonOffset, false);
        ifFalse.accept((Visitor)this);
        return false;
    }

    public boolean visit(ConstantDeclaration classConstantDeclaration) {
        this.pushKeyword(classConstantDeclaration.getStart(), 5, true, false);
        List leftNodes = classConstantDeclaration.names();
        List rightNodes = classConstantDeclaration.initializers();
        this.visitNodeLists(leftNodes, rightNodes, NodeTypes.TypeOperator.ASSIGNMENT, NodeTypes.TypePunctuation.COMMA);
        int end = ((ASTNode)rightNodes.get(rightNodes.size() - 1)).getEnd();
        this.findAndPushPunctuationNode(NodeTypes.TypePunctuation.SEMICOLON, end, false, true);
        return false;
    }

    private void visitNodeLists(List<? extends ASTNode> leftNodes, List<? extends ASTNode> rightNodes, NodeTypes.TypeOperator pairsOperator, NodeTypes.TypePunctuation pairsSeparator) {
        int leftSize = leftNodes.size();
        int i = 0;
        while (i < leftSize) {
            String text;
            int startIndex;
            ASTNode left = leftNodes.get(i);
            ASTNode right = rightNodes != null ? rightNodes.get(i) : null;
            left.accept((Visitor)this);
            if (right != null && pairsOperator != null) {
                startIndex = left.getEnd();
                text = this.document.get(startIndex, right.getStart());
                String typeStr = pairsOperator.toString();
                this.pushTypeOperator(pairsOperator, startIndex += text.indexOf(typeStr), false);
                right.accept((Visitor)this);
            }
            if (pairsSeparator != null && i + 1 < leftNodes.size()) {
                startIndex = left.getEnd();
                text = this.document.get(startIndex, leftNodes.get(i + 1).getStart());
                String separatorStr = pairsSeparator.toString();
                this.pushTypePunctuation(pairsSeparator, startIndex += text.indexOf(separatorStr));
            }
            ++i;
        }
    }

    public boolean visit(ContinueStatement continueStatement) {
        int continueStart = continueStatement.getStart();
        int end = continueStatement.getEnd() - 1;
        Expression expression = continueStatement.getExpression();
        this.pushKeyword(continueStart, 8, true, expression == null);
        if (expression != null) {
            expression.accept((Visitor)this);
        }
        this.findAndPushPunctuationNode(NodeTypes.TypePunctuation.SEMICOLON, end, false, true);
        return false;
    }

    public boolean visit(DeclareStatement declareStatement) {
        Statement body = declareStatement.getBody();
        List directiveNames = declareStatement.directiveNames();
        List directiveValues = declareStatement.directiveValues();
        int start = declareStatement.getStart();
        this.pushFunctionInvocationName((ASTNode)declareStatement, start, start + 7);
        int openParen = PHPFormatterNodeBuilder.locateCharForward(this.document, '(', start + 7, this.comments);
        int closeParen = PHPFormatterNodeBuilder.locateCharBackward(this.document, ')', body != null ? body.getStart() : declareStatement.getEnd(), this.comments);
        FormatterPHPParenthesesNode parenthesesNode = new FormatterPHPParenthesesNode((IFormatterDocument)this.document, NodeTypes.TypeBracket.DECLARATION_PARENTHESIS);
        parenthesesNode.setBegin(AbstractFormatterNodeBuilder.createTextNode((IFormatterDocument)this.document, (int)openParen, (int)(openParen + 1)));
        this.builder.push((IFormatterContainerNode)parenthesesNode);
        this.visitNodeLists(directiveNames, directiveValues, NodeTypes.TypeOperator.ASSIGNMENT, NodeTypes.TypePunctuation.COMMA);
        this.builder.checkedPop((IFormatterContainerNode)parenthesesNode, -1);
        parenthesesNode.setEnd(AbstractFormatterNodeBuilder.createTextNode((IFormatterDocument)this.document, (int)closeParen, (int)(closeParen + 1)));
        if (body != null) {
            body.accept((Visitor)this);
        }
        return false;
    }

    public boolean visit(EchoStatement echoStatement) {
        int echoStart = echoStatement.getStart();
        this.pushFunctionInvocationName((ASTNode)echoStatement, echoStart, echoStart + 4);
        List expressions = echoStatement.expressions();
        this.pushParametersInParentheses(echoStart + 4, echoStatement.getEnd(), expressions, NodeTypes.TypePunctuation.COMMA, false, NodeTypes.TypeBracket.INVOCATION_PARENTHESIS, true);
        int end = Math.max(echoStatement.getEnd() - 1, ((Expression)expressions.get(expressions.size() - 1)).getEnd());
        this.findAndPushPunctuationNode(NodeTypes.TypePunctuation.SEMICOLON, end, false, true);
        return false;
    }

    public boolean visit(EmptyStatement emptyStatement) {
        this.visitTextNode((ASTNode)emptyStatement, true, 0);
        return false;
    }

    public boolean visit(ExpressionStatement expressionStatement) {
        int expressionEnd = expressionStatement.getEnd();
        boolean endsWithSemicolon = this.document.charAt(expressionEnd - 1) == ';';
        FormatterPHPExpressionWrapperNode expressionNode = new FormatterPHPExpressionWrapperNode((IFormatterDocument)this.document);
        int start = expressionStatement.getStart();
        int end = expressionEnd;
        if (endsWithSemicolon) {
            --end;
        }
        expressionNode.setBegin(AbstractFormatterNodeBuilder.createTextNode((IFormatterDocument)this.document, (int)start, (int)start));
        this.builder.push((IFormatterContainerNode)expressionNode);
        expressionStatement.childrenAccept((Visitor)this);
        expressionNode.setEnd(AbstractFormatterNodeBuilder.createTextNode((IFormatterDocument)this.document, (int)end, (int)end));
        this.builder.checkedPop((IFormatterContainerNode)expressionNode, -1);
        if (endsWithSemicolon) {
            this.findAndPushPunctuationNode(NodeTypes.TypePunctuation.SEMICOLON, end, false, true);
        }
        return false;
    }

    public boolean visit(FieldAccess fieldAccess) {
        VariableBase dispatcher = fieldAccess.getDispatcher();
        VariableBase member = fieldAccess.getMember();
        this.visitLeftRightExpression((ASTNode)fieldAccess, (ASTNode)dispatcher, (ASTNode)member, INVOCATION_ARROW);
        return false;
    }

    public boolean visit(ForStatement forStatement) {
        List initializers = forStatement.initializers();
        List conditions = forStatement.conditions();
        List updaters = forStatement.updaters();
        Statement body = forStatement.getBody();
        int declarationEndOffset = forStatement.getStart() + 3;
        this.visitCommonDeclaration((ASTNode)forStatement, declarationEndOffset, true);
        int expressionEndOffset = body != null ? body.getStart() : forStatement.getEnd();
        int openParen = PHPFormatterNodeBuilder.locateCharForward(this.document, '(', declarationEndOffset, this.comments);
        int closeParen = PHPFormatterNodeBuilder.locateCharBackward(this.document, ')', expressionEndOffset, this.comments);
        FormatterPHPParenthesesNode parenthesesNode = new FormatterPHPParenthesesNode((IFormatterDocument)this.document, NodeTypes.TypeBracket.LOOP_PARENTHESIS);
        parenthesesNode.setBegin(AbstractFormatterNodeBuilder.createTextNode((IFormatterDocument)this.document, (int)openParen, (int)(openParen + 1)));
        this.builder.push((IFormatterContainerNode)parenthesesNode);
        this.visitNodeLists(initializers, null, null, NodeTypes.TypePunctuation.COMMA);
        int semicolonOffset = PHPFormatterNodeBuilder.locateCharForward(this.document, ';', declarationEndOffset, this.comments);
        this.pushTypePunctuation(NodeTypes.TypePunctuation.FOR_SEMICOLON, semicolonOffset);
        this.visitNodeLists(conditions, null, null, NodeTypes.TypePunctuation.COMMA);
        semicolonOffset = PHPFormatterNodeBuilder.locateCharForward(this.document, ';', semicolonOffset + 1, this.comments);
        this.pushTypePunctuation(NodeTypes.TypePunctuation.FOR_SEMICOLON, semicolonOffset);
        this.visitNodeLists(updaters, null, null, NodeTypes.TypePunctuation.COMMA);
        this.builder.checkedPop((IFormatterContainerNode)parenthesesNode, -1);
        parenthesesNode.setEnd(AbstractFormatterNodeBuilder.createTextNode((IFormatterDocument)this.document, (int)closeParen, (int)(closeParen + 1)));
        this.commonVisitBlockBody((ASTNode)forStatement, (ASTNode)body);
        return false;
    }

    public boolean visit(ForEachStatement forEachStatement) {
        Expression expression = forEachStatement.getExpression();
        Expression key = forEachStatement.getKey();
        Expression value = forEachStatement.getValue();
        Statement body = forEachStatement.getStatement();
        int declarationEndOffset = forEachStatement.getStart() + 7;
        this.visitCommonDeclaration((ASTNode)forEachStatement, declarationEndOffset, true);
        int expressionEndOffset = body != null ? body.getStart() : forEachStatement.getEnd();
        int openParen = PHPFormatterNodeBuilder.locateCharForward(this.document, '(', declarationEndOffset, this.comments);
        int closeParen = PHPFormatterNodeBuilder.locateCharBackward(this.document, ')', expressionEndOffset, this.comments);
        FormatterPHPParenthesesNode parenthesesNode = new FormatterPHPParenthesesNode((IFormatterDocument)this.document, NodeTypes.TypeBracket.LOOP_PARENTHESIS);
        parenthesesNode.setBegin(AbstractFormatterNodeBuilder.createTextNode((IFormatterDocument)this.document, (int)openParen, (int)(openParen + 1)));
        this.builder.push((IFormatterContainerNode)parenthesesNode);
        this.visitTextNode((ASTNode)expression, true, 0);
        int endLookupForAs = key != null ? key.getStart() : value.getStart();
        String txt = this.document.get(expression.getEnd(), endLookupForAs);
        int asStart = expression.getEnd() + txt.toLowerCase().indexOf("as");
        this.visitTextNode(asStart, asStart + 2, true, 1, 1);
        if (key != null) {
            this.visitLeftRightExpression(null, (ASTNode)key, (ASTNode)value, NodeTypes.TypeOperator.KEY_VALUE.toString());
        } else {
            this.visitTextNode((ASTNode)value, true, 1);
        }
        this.builder.checkedPop((IFormatterContainerNode)parenthesesNode, -1);
        parenthesesNode.setEnd(AbstractFormatterNodeBuilder.createTextNode((IFormatterDocument)this.document, (int)closeParen, (int)(closeParen + 1)));
        this.commonVisitBlockBody((ASTNode)forEachStatement, (ASTNode)body);
        return false;
    }

    public boolean visit(WhileStatement whileStatement) {
        this.visitCommonLoopBlock((ASTNode)whileStatement, whileStatement.getStart() + 5, whileStatement.getBody(), (ASTNode)whileStatement.getCondition());
        return false;
    }

    public boolean visit(DoStatement doStatement) {
        Statement body = doStatement.getBody();
        this.visitCommonLoopBlock((ASTNode)doStatement, doStatement.getStart() + 2, body, null);
        FormatterPHPNonBlockedWhileNode whileNode = new FormatterPHPNonBlockedWhileNode((IFormatterDocument)this.document);
        int whileBeginOffset = PHPFormatterNodeBuilder.locateCharForward(this.document, 'w', body.getEnd(), this.comments);
        int conditionEnd = this.locateCharMatchInLine(doStatement.getEnd(), SEMICOLON, this.document, true);
        whileNode.setBegin(AbstractFormatterNodeBuilder.createTextNode((IFormatterDocument)this.document, (int)whileBeginOffset, (int)conditionEnd));
        this.builder.push((IFormatterContainerNode)whileNode);
        this.builder.checkedPop((IFormatterContainerNode)whileNode, -1);
        return false;
    }

    public boolean visit(FunctionDeclaration functionDeclaration) {
        this.visitFunctionDeclaration((ASTNode)functionDeclaration, functionDeclaration.getFunctionName(), functionDeclaration.formalParameters(), null, functionDeclaration.getBody());
        return false;
    }

    public boolean visit(FunctionInvocation functionInvocation) {
        this.visitFunctionInvocation(functionInvocation);
        return false;
    }

    public boolean visit(GlobalStatement globalStatement) {
        this.pushKeyword(globalStatement.getStart(), 6, true, false);
        List variables = globalStatement.variables();
        this.visitNodeLists(variables, null, null, NodeTypes.TypePunctuation.COMMA);
        this.findAndPushPunctuationNode(NodeTypes.TypePunctuation.SEMICOLON, globalStatement.getEnd() - 1, false, true);
        return false;
    }

    public boolean visit(GotoLabel gotoLabel) {
        FormatterPHPLineStartingNode lineStartingNode = new FormatterPHPLineStartingNode((IFormatterDocument)this.document);
        int start = gotoLabel.getStart();
        int end = gotoLabel.getEnd();
        int trimmedLength = this.document.get(start, end - 1).trim().length();
        int labelEnd = end - (end - start - trimmedLength);
        lineStartingNode.setBegin(AbstractFormatterNodeBuilder.createTextNode((IFormatterDocument)this.document, (int)start, (int)labelEnd));
        this.builder.push((IFormatterContainerNode)lineStartingNode);
        this.builder.checkedPop((IFormatterContainerNode)lineStartingNode, -1);
        this.findAndPushPunctuationNode(NodeTypes.TypePunctuation.GOTO_COLON, end - 1, false, true);
        return false;
    }

    public boolean visit(GotoStatement gotoStatement) {
        Identifier label = gotoStatement.getLabel();
        this.pushKeyword(gotoStatement.getStart(), 4, true, false);
        label.accept((Visitor)this);
        this.findAndPushPunctuationNode(NodeTypes.TypePunctuation.SEMICOLON, gotoStatement.getEnd() - 1, false, true);
        return false;
    }

    public boolean visit(Identifier identifier) {
        this.visitTextNode((ASTNode)identifier, true, 0);
        return false;
    }

    public boolean visit(IgnoreError ignoreError) {
        int start = ignoreError.getStart();
        int end = start + 1;
        this.visitTextNode(start, end, true, 0);
        ignoreError.getExpression().accept((Visitor)this);
        return false;
    }

    public boolean visit(Include include) {
        int includeStart = include.getStart();
        int keywordLength = Include.getType((int)include.getIncludeType()).length();
        boolean firstInLine = include.getParent().getType() != 35;
        this.pushKeyword(includeStart, keywordLength, firstInLine, false, true);
        Expression expression = include.getExpression();
        expression.accept((Visitor)this);
        return false;
    }

    public boolean visit(InfixExpression infixExpression) {
        Expression left = infixExpression.getLeft();
        Expression right = infixExpression.getRight();
        String operatorStr = InfixExpression.getOperator((int)infixExpression.getOperator());
        String operatorStringAsIs = this.document.get(left.getEnd(), right.getStart()).trim();
        if (operatorStr.length() < operatorStringAsIs.length()) {
            operatorStringAsIs = operatorStr;
        }
        this.visitLeftRightExpression((ASTNode)infixExpression, (ASTNode)left, (ASTNode)right, operatorStringAsIs);
        return false;
    }

    public boolean visit(InLineHtml inLineHtml) {
        this.visitTextNode((ASTNode)inLineHtml, false, 0);
        return false;
    }

    public boolean visit(InstanceOfExpression instanceOfExpression) {
        Expression expression = instanceOfExpression.getExpression();
        ClassName className = instanceOfExpression.getClassName();
        expression.accept((Visitor)this);
        int exprEnd = expression.getEnd();
        String txt = this.document.get(exprEnd, className.getStart());
        int instanceOfStart = exprEnd + txt.toLowerCase().indexOf("instanceof");
        this.visitTextNode(instanceOfStart, instanceOfStart + 10, true, 1);
        className.accept((Visitor)this);
        return false;
    }

    public boolean visit(InterfaceDeclaration interfaceDeclaration) {
        this.visitTypeDeclaration((TypeDeclaration)interfaceDeclaration);
        return false;
    }

    public boolean visit(LambdaFunctionDeclaration lambdaFunctionDeclaration) {
        int staticStart;
        int lambdaStart;
        if (lambdaFunctionDeclaration.isStatic() && (lambdaStart = lambdaFunctionDeclaration.getStart()) != (staticStart = PHPFormatterNodeBuilder.locateCharBackward((FormatterDocument)this.document, (char)'s', (int)lambdaStart))) {
            FormatterPHPKeywordNode staticNode = new FormatterPHPKeywordNode((IFormatterDocument)this.document, false, false);
            staticNode.setBegin(AbstractFormatterNodeBuilder.createTextNode((IFormatterDocument)this.document, (int)staticStart, (int)(staticStart + 6)));
            this.builder.push((IFormatterContainerNode)staticNode);
            this.builder.checkedPop((IFormatterContainerNode)staticNode, -1);
        }
        this.visitFunctionDeclaration((ASTNode)lambdaFunctionDeclaration, null, lambdaFunctionDeclaration.formalParameters(), lambdaFunctionDeclaration.lexicalVariables(), lambdaFunctionDeclaration.getBody());
        return false;
    }

    public boolean visit(ListVariable listVariable) {
        List variables = listVariable.variables();
        int start = listVariable.getStart();
        this.pushFunctionInvocationName((ASTNode)listVariable, start, start + 4);
        this.pushParametersInParentheses(start + 4, listVariable.getEnd(), variables, NodeTypes.TypePunctuation.COMMA, false, NodeTypes.TypeBracket.DECLARATION_PARENTHESIS, false);
        return false;
    }

    public boolean visit(MethodDeclaration methodDeclaration) {
        FunctionDeclaration function = methodDeclaration.getFunction();
        this.visitModifiers(methodDeclaration.getStart(), function.getStart());
        function.accept((Visitor)this);
        return false;
    }

    public boolean visit(FieldsDeclaration fieldsDeclaration) {
        Variable[] variableNames = fieldsDeclaration.getVariableNames();
        Variable firstVariable = variableNames[0];
        this.visitModifiers(fieldsDeclaration.getStart(), firstVariable.getStart());
        Expression[] initialValues = fieldsDeclaration.getInitialValues();
        List<Variable> variablesList = Arrays.asList(variableNames);
        List<Expression> valuesList = initialValues != null ? Arrays.asList(initialValues) : null;
        this.visitNodeLists(variablesList, valuesList, NodeTypes.TypeOperator.ASSIGNMENT, NodeTypes.TypePunctuation.COMMA);
        this.findAndPushPunctuationNode(NodeTypes.TypePunctuation.SEMICOLON, fieldsDeclaration.getEnd() - 1, false, true);
        return false;
    }

    public boolean visit(MethodInvocation methodInvocation) {
        this.visitLeftRightExpression((ASTNode)methodInvocation, (ASTNode)methodInvocation.getDispatcher(), (ASTNode)methodInvocation.getMethod(), INVOCATION_ARROW);
        return false;
    }

    public boolean visit(StaticMethodInvocation staticMethodInvocation) {
        this.visitLeftRightExpression((ASTNode)staticMethodInvocation, (ASTNode)staticMethodInvocation.getClassName(), (ASTNode)staticMethodInvocation.getMethod(), STATIC_INVOCATION);
        return false;
    }

    public boolean visit(NamespaceDeclaration namespaceDeclaration) {
        int start = namespaceDeclaration.getStart();
        this.pushKeyword(start, 9, true, false);
        int end = start + 9;
        NamespaceName namespaceName = namespaceDeclaration.getName();
        if (namespaceName != null) {
            namespaceName.accept((Visitor)this);
            end = namespaceName.getEnd();
        }
        this.findAndPushPunctuationNode(NodeTypes.TypePunctuation.SEMICOLON, end, false, true);
        FormatterPHPNamespaceBlockNode bodyNode = new FormatterPHPNamespaceBlockNode((IFormatterDocument)this.document);
        Block body = namespaceDeclaration.getBody();
        if (body.isCurly()) {
            body.accept((Visitor)this);
        } else {
            int bodyStart = body.getStart();
            int bodyEnd = body.getEnd();
            bodyNode.setBegin(AbstractFormatterNodeBuilder.createTextNode((IFormatterDocument)this.document, (int)bodyStart, (int)bodyStart));
            this.builder.push((IFormatterContainerNode)bodyNode);
            body.childrenAccept((Visitor)this);
            bodyNode.setEnd(AbstractFormatterNodeBuilder.createTextNode((IFormatterDocument)this.document, (int)bodyEnd, (int)bodyEnd));
            this.builder.checkedPop((IFormatterContainerNode)bodyNode, namespaceDeclaration.getEnd());
        }
        return false;
    }

    public boolean visit(NamespaceName namespaceName) {
        List segments = namespaceName.segments();
        int start = namespaceName.getStart();
        if (namespaceName.isGlobal()) {
            start = PHPFormatterNodeBuilder.locateCharBackward(this.document, '\\', start, this.comments);
            this.pushTypePunctuation(NodeTypes.TypePunctuation.NAMESPACE_SEPARATOR, start);
        }
        this.visitNodeLists(segments, null, null, NodeTypes.TypePunctuation.NAMESPACE_SEPARATOR);
        return false;
    }

    public boolean visit(ParenthesisExpression parenthesisExpression) {
        FormatterPHPParenthesesNode parenthesesNode = new FormatterPHPParenthesesNode((IFormatterDocument)this.document, NodeTypes.TypeBracket.PARENTHESIS);
        int start = parenthesisExpression.getStart();
        parenthesesNode.setBegin(AbstractFormatterNodeBuilder.createTextNode((IFormatterDocument)this.document, (int)start, (int)(start + 1)));
        this.builder.push((IFormatterContainerNode)parenthesesNode);
        parenthesisExpression.childrenAccept((Visitor)this);
        this.builder.checkedPop((IFormatterContainerNode)parenthesesNode, -1);
        int end = parenthesisExpression.getEnd();
        parenthesesNode.setEnd(AbstractFormatterNodeBuilder.createTextNode((IFormatterDocument)this.document, (int)(end - 1), (int)end));
        return false;
    }

    public boolean visit(PostfixExpression postfixExpression) {
        VariableBase var = postfixExpression.getVariable();
        NodeTypes.TypeOperator op = postfixExpression.getOperator() == 0 ? NodeTypes.TypeOperator.POSTFIX_INCREMENT : NodeTypes.TypeOperator.POSTFIX_DECREMENT;
        var.accept((Visitor)this);
        int leftOffset = var.getEnd();
        int operatorOffset = this.document.get(leftOffset, postfixExpression.getEnd()).indexOf(op.toString()) + leftOffset;
        this.pushTypeOperator(op, operatorOffset, false);
        return false;
    }

    public boolean visit(PrefixExpression prefixExpression) {
        VariableBase var = prefixExpression.getVariable();
        NodeTypes.TypeOperator op = prefixExpression.getOperator() == 0 ? NodeTypes.TypeOperator.PREFIX_INCREMENT : NodeTypes.TypeOperator.PREFIX_DECREMENT;
        int leftOffset = prefixExpression.getStart();
        int operatorOffset = this.document.get(leftOffset, var.getStart()).indexOf(op.toString()) + leftOffset;
        this.pushTypeOperator(op, operatorOffset, false);
        var.accept((Visitor)this);
        return false;
    }

    public boolean visit(Quote quote) {
        int quoteType = quote.getQuoteType();
        String quoteStr = this.document.get(quote.getStart(), quote.getEnd());
        if (quoteType == 2 || quoteType == 3 || LINE_SPLIT_PATTERN.split(quoteStr, 2).length == 2) {
            FormatterPHPHeredocNode heredocNode = new FormatterPHPHeredocNode((IFormatterDocument)this.document, quote.getStart(), quote.getEnd());
            IFormatterContainerNode parentNode = this.builder.peek();
            parentNode.addChild((IFormatterNode)heredocNode);
        } else {
            this.visitTextNode((ASTNode)quote, true, 0);
        }
        return false;
    }

    public boolean visit(Reference reference) {
        int start = reference.getStart();
        int end = start + 1;
        this.visitTextNode(start, end, true, 0);
        reference.getExpression().accept((Visitor)this);
        return false;
    }

    public boolean visit(ReflectionVariable reflectionVariable) {
        int start = reflectionVariable.getStart();
        int end = start + 1;
        this.visitTextNode(start, end, true, 0);
        reflectionVariable.getName().accept((Visitor)this);
        return false;
    }

    public boolean visit(ReturnStatement returnStatement) {
        int returnStart = returnStatement.getStart();
        Expression expression = returnStatement.getExpression();
        this.pushKeyword(returnStart, 6, true, expression == null);
        if (expression != null) {
            expression.accept((Visitor)this);
        }
        this.findAndPushPunctuationNode(NodeTypes.TypePunctuation.SEMICOLON, returnStatement.getEnd() - 1, false, true);
        return false;
    }

    public boolean visit(Scalar scalar) {
        String[] split;
        if (scalar.getScalarType() == 2 && (split = LINE_SPLIT_PATTERN.split(scalar.getStringValue(), 2)).length > 1) {
            FormatterPHPExcludedTextNode heredocNode = new FormatterPHPExcludedTextNode((IFormatterDocument)this.document, 0, 0);
            heredocNode.setBegin(AbstractFormatterNodeBuilder.createTextNode((IFormatterDocument)this.document, (int)scalar.getStart(), (int)scalar.getEnd()));
            IFormatterContainerNode parentNode = this.builder.peek();
            parentNode.addChild((IFormatterNode)heredocNode);
            return false;
        }
        this.visitTextNode((ASTNode)scalar, true, 0);
        return false;
    }

    public boolean visit(StaticConstantAccess classConstantAccess) {
        this.visitLeftRightExpression((ASTNode)classConstantAccess, (ASTNode)classConstantAccess.getClassName(), (ASTNode)classConstantAccess.getConstant(), NodeTypes.TypeOperator.STATIC_INVOCATION.toString());
        return false;
    }

    public boolean visit(StaticFieldAccess staticFieldAccess) {
        this.visitLeftRightExpression((ASTNode)staticFieldAccess, (ASTNode)staticFieldAccess.getClassName(), (ASTNode)staticFieldAccess.getField(), NodeTypes.TypeOperator.STATIC_INVOCATION.toString());
        return false;
    }

    public boolean visit(StaticStatement staticStatement) {
        this.pushKeyword(staticStatement.getStart(), 6, true, false);
        List expressions = staticStatement.expressions();
        this.visitNodeLists(expressions, null, null, NodeTypes.TypePunctuation.COMMA);
        this.findAndPushPunctuationNode(NodeTypes.TypePunctuation.SEMICOLON, staticStatement.getEnd() - 1, false, true);
        return false;
    }

    public boolean visit(SwitchStatement switchStatement) {
        Comment comment;
        Block body = switchStatement.getBody();
        boolean isAlternativeSyntax = !body.isCurly();
        FormatterPHPDeclarationNode switchNode = new FormatterPHPDeclarationNode((IFormatterDocument)this.document, true, (ASTNode)switchStatement);
        int rightParenthesis = PHPFormatterNodeBuilder.locateCharBackward(this.document, ')', body.getStart(), this.comments);
        switchNode.setBegin(AbstractFormatterNodeBuilder.createTextNode((IFormatterDocument)this.document, (int)switchStatement.getStart(), (int)(rightParenthesis + 1)));
        this.builder.push((IFormatterContainerNode)switchNode);
        this.builder.checkedPop((IFormatterContainerNode)switchNode, -1);
        int blockStart = body.getStart();
        FormatterPHPSwitchNode blockNode = new FormatterPHPSwitchNode((IFormatterDocument)this.document);
        blockNode.setBegin(AbstractFormatterNodeBuilder.createTextNode((IFormatterDocument)this.document, (int)blockStart, (int)(blockStart + 1)));
        this.builder.push((IFormatterContainerNode)blockNode);
        body.childrenAccept((Visitor)this);
        int endingOffset = switchStatement.getEnd();
        --endingOffset;
        if (isAlternativeSyntax) {
            endingOffset -= 8;
        }
        if (this.hasAnyCommentBefore(endingOffset) && (comment = PHPDocUtils.getCommentByType(this.comments, (int)endingOffset, (String)this.document.getText(), (int)-1)) != null) {
            blockNode.addChild((IFormatterNode)AbstractFormatterNodeBuilder.createTextNode((IFormatterDocument)this.document, (int)comment.getStart(), (int)comment.getEnd()));
        }
        blockNode.setEnd(AbstractFormatterNodeBuilder.createTextNode((IFormatterDocument)this.document, (int)endingOffset, (int)(endingOffset + 1)));
        this.builder.checkedPop((IFormatterContainerNode)blockNode, -1);
        return false;
    }

    public boolean visit(SwitchCase switchCase) {
        List actions = switchCase.actions();
        boolean hasBlockedChild = actions.size() == 1 && ((Statement)actions.get(0)).getType() == 6;
        int endCaseOffset = switchCase.isDefault() ? switchCase.getStart() + 7 : switchCase.getValue().getEnd();
        int colonOffset = PHPFormatterNodeBuilder.locateCharForward(this.document, ':', endCaseOffset, this.comments);
        FormatterPHPExpressionWrapperNode caseNode = new FormatterPHPExpressionWrapperNode((IFormatterDocument)this.document);
        int valueEnd = switchCase.isDefault() ? switchCase.getStart() + 7 : switchCase.getValue().getEnd();
        caseNode.setBegin(AbstractFormatterNodeBuilder.createTextNode((IFormatterDocument)this.document, (int)switchCase.getStart(), (int)valueEnd));
        caseNode.setEnd(AbstractFormatterNodeBuilder.createTextNode((IFormatterDocument)this.document, (int)(colonOffset + 1), (int)(colonOffset + 1)));
        this.builder.push((IFormatterContainerNode)caseNode);
        FormatterPHPCaseColonNode caseColonNode = new FormatterPHPCaseColonNode((IFormatterDocument)this.document, hasBlockedChild);
        caseColonNode.setBegin(AbstractFormatterNodeBuilder.createTextNode((IFormatterDocument)this.document, (int)colonOffset, (int)(colonOffset + 1)));
        this.builder.push((IFormatterContainerNode)caseColonNode);
        this.builder.checkedPop((IFormatterContainerNode)caseColonNode, -1);
        this.builder.checkedPop((IFormatterContainerNode)caseNode, -1);
        FormatterPHPCaseBodyNode caseBodyNode = new FormatterPHPCaseBodyNode((IFormatterDocument)this.document, hasBlockedChild, hasBlockedChild && this.hasAnyCommentBefore(((Statement)actions.get(0)).getStart()));
        if (hasBlockedChild) {
            Block body = (Block)actions.get(0);
            caseBodyNode.setBegin(AbstractFormatterNodeBuilder.createTextNode((IFormatterDocument)this.document, (int)body.getStart(), (int)(body.getStart() + 1)));
            this.builder.push((IFormatterContainerNode)caseBodyNode);
            body.childrenAccept((Visitor)this);
            int endingOffset = body.getEnd() - 1;
            this.builder.checkedPop((IFormatterContainerNode)caseBodyNode, endingOffset);
            int end = this.locateCharMatchInLine(endingOffset + 1, SEMICOLON_AND_COLON, this.document, false);
            caseBodyNode.setEnd(AbstractFormatterNodeBuilder.createTextNode((IFormatterDocument)this.document, (int)endingOffset, (int)end));
        } else if (!actions.isEmpty()) {
            int start = ((Statement)actions.get(0)).getStart();
            if (this.hasAnyCommentBefore(start)) {
                start = caseColonNode.getEndOffset();
            }
            int end = ((Statement)actions.get(actions.size() - 1)).getEnd();
            caseBodyNode.setBegin(AbstractFormatterNodeBuilder.createTextNode((IFormatterDocument)this.document, (int)start, (int)start));
            this.builder.push((IFormatterContainerNode)caseBodyNode);
            for (Statement st : actions) {
                st.accept((Visitor)this);
            }
            this.builder.checkedPop((IFormatterContainerNode)caseBodyNode, switchCase.getEnd());
            caseBodyNode.setEnd(AbstractFormatterNodeBuilder.createTextNode((IFormatterDocument)this.document, (int)end, (int)end));
        }
        return false;
    }

    public boolean visit(CastExpression castExpression) {
        Expression expression = castExpression.getExpression();
        int castCloserOffset = PHPFormatterNodeBuilder.locateCharBackward(this.document, ')', expression.getStart(), this.comments);
        this.visitTextNode(castExpression.getStart(), castCloserOffset, true, 0);
        expression.accept((Visitor)this);
        return false;
    }

    public boolean visit(CatchClause catchClause) {
        int declarationEnd = catchClause.getClassName().getEnd();
        declarationEnd = PHPFormatterNodeBuilder.locateCharForward(this.document, ')', declarationEnd, this.comments) + 1;
        this.visitCommonDeclaration((ASTNode)catchClause, declarationEnd, true);
        this.visitBlockNode(catchClause.getBody(), (ASTNode)catchClause, true);
        return false;
    }

    public boolean visit(ThrowStatement throwStatement) {
        this.pushKeyword(throwStatement.getStart(), 5, true, false);
        Expression expression = throwStatement.getExpression();
        if (expression instanceof ParenthesisExpression) {
            expression.accept((Visitor)this);
        } else {
            String text = this.document.get(throwStatement.getStart() + 5, expression.getStart());
            if (text.trim().startsWith("(")) {
                this.pushNodeInParentheses('(', ')', throwStatement.getStart() + 5, expression.getEnd(), (ASTNode)expression, NodeTypes.TypeBracket.PARENTHESIS);
            } else {
                expression.accept((Visitor)this);
            }
        }
        this.findAndPushPunctuationNode(NodeTypes.TypePunctuation.SEMICOLON, expression.getEnd(), false, true);
        return false;
    }

    public boolean visit(TryStatement tryStatement) {
        this.visitCommonDeclaration((ASTNode)tryStatement, tryStatement.getStart() + 3, true);
        this.visitBlockNode(tryStatement.getBody(), (ASTNode)tryStatement, true);
        List catchClauses = tryStatement.catchClauses();
        for (CatchClause catchClause : catchClauses) {
            catchClause.accept((Visitor)this);
        }
        return false;
    }

    public boolean visit(UnaryOperation unaryOperation) {
        Expression expression = unaryOperation.getExpression();
        String operationString = unaryOperation.getOperationString();
        NodeTypes.TypeOperator typeOperator = NodeTypes.TypeOperator.getTypeOperator((String)operationString);
        this.pushTypeOperator(typeOperator, unaryOperation.getStart(), true);
        expression.accept((Visitor)this);
        return false;
    }

    public boolean visit(UseStatement useStatement) {
        this.pushKeyword(useStatement.getStart(), 3, true, false);
        List parts = useStatement.parts();
        this.visitNodeLists(parts, null, null, NodeTypes.TypePunctuation.COMMA);
        this.findAndPushPunctuationNode(NodeTypes.TypePunctuation.SEMICOLON, useStatement.getEnd() - 1, false, true);
        return false;
    }

    public boolean visit(UseStatementPart useStatementPart) {
        NamespaceName namespaceName = useStatementPart.getName();
        Identifier alias = useStatementPart.getAlias();
        namespaceName.accept((Visitor)this);
        if (alias != null) {
            String text = this.document.get(namespaceName.getEnd(), alias.getStart());
            int asOffset = text.toLowerCase().indexOf("as");
            this.pushKeyword(asOffset += namespaceName.getEnd(), 2, false, false);
            alias.accept((Visitor)this);
        }
        return false;
    }

    public boolean visit(Variable variable) {
        this.visitTextNode((ASTNode)variable, true, 0);
        return false;
    }

    public boolean visit(ChainingInstanceCall chainingCall) {
        return false;
    }

    public boolean visit(FullyQualifiedTraitMethodReference node) {
        this.visitLeftRightExpression((ASTNode)node, (ASTNode)node.getClassName(), (ASTNode)node.getFunctionName(), NodeTypes.TypeOperator.STATIC_INVOCATION.toString());
        return false;
    }

    public boolean visit(PHPArrayDereferenceList dereferenceList) {
        return super.visit(dereferenceList);
    }

    public boolean visit(DereferenceNode dereferenceNode) {
        this.pushNodeInParentheses('[', ']', dereferenceNode.getStart(), dereferenceNode.getEnd(), (ASTNode)dereferenceNode.getName(), NodeTypes.TypeBracket.ARRAY_SQUARE);
        return false;
    }

    public boolean visit(TraitAlias node) {
        FormatterPHPTraitPrecedenceWrapperNode wrapperNode = new FormatterPHPTraitPrecedenceWrapperNode((IFormatterDocument)this.document);
        int start = node.getStart();
        int end = node.getEnd();
        wrapperNode.setBegin(AbstractFormatterNodeBuilder.createTextNode((IFormatterDocument)this.document, (int)start, (int)start));
        this.builder.push((IFormatterContainerNode)wrapperNode);
        Expression traitMethod = node.getTraitMethod();
        traitMethod.accept((Visitor)this);
        String modifier = PHPFlags.toString((int)node.getModifier());
        Identifier functionName = node.getFunctionName();
        int traitMethodEndOffset = traitMethod.getEnd();
        String txt = this.document.get(traitMethodEndOffset, functionName != null ? functionName.getStart() : node.getModifierOffset());
        int asStart = traitMethodEndOffset + txt.toLowerCase().indexOf("as");
        this.visitTextNode(asStart, asStart + 2, true, 1, 1);
        int modifierOffset = node.getModifierOffset();
        if (txt.indexOf(modifier) > -1 || functionName == null) {
            this.visitTextNode(modifierOffset, modifierOffset + modifier.length(), true, 1, functionName != null ? 1 : 0);
        }
        if (functionName != null) {
            functionName.accept((Visitor)this);
        }
        wrapperNode.setEnd(AbstractFormatterNodeBuilder.createTextNode((IFormatterDocument)this.document, (int)end, (int)end));
        this.builder.checkedPop((IFormatterContainerNode)wrapperNode, -1);
        this.findAndPushPunctuationNode(NodeTypes.TypePunctuation.SEMICOLON, node.getEnd() - 1, false, true);
        return false;
    }

    public boolean visit(TraitDeclaration traitDeclaration) {
        this.visitTypeDeclaration((TypeDeclaration)traitDeclaration);
        return false;
    }

    public boolean visit(TraitPrecedence node) {
        FormatterPHPTraitPrecedenceWrapperNode wrapperNode = new FormatterPHPTraitPrecedenceWrapperNode((IFormatterDocument)this.document);
        int start = node.getStart();
        int end = node.getEnd();
        wrapperNode.setBegin(AbstractFormatterNodeBuilder.createTextNode((IFormatterDocument)this.document, (int)start, (int)start));
        this.builder.push((IFormatterContainerNode)wrapperNode);
        FullyQualifiedTraitMethodReference methodReference = node.getMethodReference();
        methodReference.accept((Visitor)this);
        List trList = node.getTrList();
        int exprEnd = methodReference.getEnd();
        String txt = this.document.get(exprEnd, ((NamespaceName)trList.get(0)).getStart());
        int insteadofStart = exprEnd + txt.toLowerCase().indexOf("insteadof");
        this.visitTextNode(insteadofStart, insteadofStart + 9, true, 1, 1);
        this.visitNodeLists(trList, null, null, NodeTypes.TypePunctuation.COMMA);
        wrapperNode.setEnd(AbstractFormatterNodeBuilder.createTextNode((IFormatterDocument)this.document, (int)end, (int)end));
        this.builder.checkedPop((IFormatterContainerNode)wrapperNode, -1);
        this.findAndPushPunctuationNode(NodeTypes.TypePunctuation.SEMICOLON, ((NamespaceName)trList.get(trList.size() - 1)).getEnd() - 1, false, true);
        return false;
    }

    public boolean visit(TraitUseStatement traitUse) {
        this.pushKeyword(traitUse.getStart(), 3, true, false);
        List traitList = traitUse.getTraitList();
        this.visitNodeLists(traitList, null, null, NodeTypes.TypePunctuation.COMMA);
        List tsList = traitUse.getTsList();
        if (tsList != null) {
            int lastTraitListOffset = ((NamespaceName)traitList.get(traitList.size() - 1)).getEnd() - 1;
            int openCurlyOffset = PHPFormatterNodeBuilder.locateCharForward(this.document, '{', lastTraitListOffset, this.comments);
            FormatterPHPBlockNode blockNode = null;
            if (openCurlyOffset != lastTraitListOffset && openCurlyOffset < traitUse.getEnd()) {
                blockNode = new FormatterPHPBlockNode((IFormatterDocument)this.document, false);
                blockNode.setBegin(AbstractFormatterNodeBuilder.createTextNode((IFormatterDocument)this.document, (int)openCurlyOffset, (int)(openCurlyOffset + 1)));
                this.builder.push((IFormatterContainerNode)blockNode);
            }
            if (!tsList.isEmpty()) {
                for (TraitStatement statement : tsList) {
                    statement.accept((Visitor)this);
                }
            }
            if (blockNode != null) {
                int closeCurlyOffset = PHPFormatterNodeBuilder.locateCharBackward(this.document, '}', traitUse.getEnd(), this.comments);
                blockNode.setEnd(AbstractFormatterNodeBuilder.createTextNode((IFormatterDocument)this.document, (int)closeCurlyOffset, (int)(closeCurlyOffset + 1)));
                this.builder.checkedPop((IFormatterContainerNode)blockNode, traitUse.getEnd());
            }
        }
        return false;
    }

    private void visitTypeDeclaration(TypeDeclaration typeDeclaration) {
        Block body = typeDeclaration.getBody();
        int declarationBeginEnd = body.getStart() - 1;
        List interfaces = typeDeclaration.interfaces();
        declarationBeginEnd = interfaces != null && !interfaces.isEmpty() ? ((Identifier)interfaces.get(interfaces.size() - 1)).getEnd() : (typeDeclaration.getType() == 12 && ((ClassDeclaration)typeDeclaration).getSuperClass() != null ? ((ClassDeclaration)typeDeclaration).getSuperClass().getEnd() : typeDeclaration.getName().getEnd());
        FormatterPHPDeclarationNode typeNode = new FormatterPHPDeclarationNode((IFormatterDocument)this.document, true, (ASTNode)typeDeclaration);
        typeNode.setBegin(AbstractFormatterNodeBuilder.createTextNode((IFormatterDocument)this.document, (int)typeDeclaration.getStart(), (int)declarationBeginEnd));
        this.builder.push((IFormatterContainerNode)typeNode);
        this.builder.checkedPop((IFormatterContainerNode)typeNode, -1);
        FormatterPHPTypeBodyNode typeBodyNode = new FormatterPHPTypeBodyNode((IFormatterDocument)this.document, this.hasAnyCommentBefore(body.getStart()));
        typeBodyNode.setBegin(AbstractFormatterNodeBuilder.createTextNode((IFormatterDocument)this.document, (int)body.getStart(), (int)(body.getStart() + 1)));
        this.builder.push((IFormatterContainerNode)typeBodyNode);
        body.childrenAccept((Visitor)this);
        int end = body.getEnd();
        this.builder.checkedPop((IFormatterContainerNode)typeBodyNode, end - 1);
        typeBodyNode.setEnd(AbstractFormatterNodeBuilder.createTextNode((IFormatterDocument)this.document, (int)(end - 1), (int)end));
    }

    private void visitFunctionInvocation(FunctionInvocation functionInvocation) {
        FunctionName functionName = functionInvocation.getFunctionName();
        this.pushFunctionInvocationName((ASTNode)functionInvocation, functionName.getStart(), functionName.getEnd());
        List invocationParameters = functionInvocation.parameters();
        this.pushParametersInParentheses(functionName.getEnd(), functionInvocation.getEnd(), invocationParameters, NodeTypes.TypePunctuation.COMMA, false, NodeTypes.TypeBracket.INVOCATION_PARENTHESIS, false);
        PHPArrayDereferenceList arrayDereferenceList = functionInvocation.getArrayDereferenceList();
        if (arrayDereferenceList != null) {
            arrayDereferenceList.accept((Visitor)this);
        }
    }

    private void pushFunctionInvocationName(ASTNode invocationNode, int nameStart, int nameEnd) {
        FormatterPHPFunctionInvocationNode node = new FormatterPHPFunctionInvocationNode((IFormatterDocument)this.document, invocationNode);
        node.setBegin(AbstractFormatterNodeBuilder.createTextNode((IFormatterDocument)this.document, (int)nameStart, (int)nameEnd));
        this.builder.push((IFormatterContainerNode)node);
        this.builder.checkedPop((IFormatterContainerNode)node, -1);
    }

    private void pushParametersInParentheses(int declarationEndOffset, int expressionEndOffset, List<? extends ASTNode> parameters, NodeTypes.TypePunctuation punctuationType, boolean lookForExtraComma, NodeTypes.TypeBracket bracketsType, boolean needsMatchingBracketVerification) {
        boolean pushParenthesisNode = parameters.size() != 1 || parameters.size() == 1 && parameters.get(0).getType() != 62;
        int openParenOffset = this.builder.getNextNonWhiteCharOffset(this.document, declarationEndOffset);
        if (needsMatchingBracketVerification && pushParenthesisNode && openParenOffset > -1 && this.document.charAt(openParenOffset) == bracketsType.getLeft().charAt(0)) {
            pushParenthesisNode = PHPFormatterVisitor.isWrappedInMatchingBrackets(bracketsType, declarationEndOffset, expressionEndOffset, this.document);
        }
        FormatterPHPParenthesesNode parenthesesNode = null;
        if (pushParenthesisNode) {
            if (bracketsType.getLeft().charAt(0) == this.document.charAt(openParenOffset)) {
                parenthesesNode = new FormatterPHPParenthesesNode((IFormatterDocument)this.document, false, parameters.size(), bracketsType);
                parenthesesNode.setBegin(AbstractFormatterNodeBuilder.createTextNode((IFormatterDocument)this.document, (int)openParenOffset, (int)(openParenOffset + 1)));
            } else {
                parenthesesNode = new FormatterPHPParenthesesNode((IFormatterDocument)this.document, true, parameters.size(), bracketsType);
                parenthesesNode.setBegin(AbstractFormatterNodeBuilder.createTextNode((IFormatterDocument)this.document, (int)openParenOffset, (int)openParenOffset));
            }
            this.builder.push((IFormatterContainerNode)parenthesesNode);
        }
        if (parameters != null && parameters.size() > 0) {
            int lastParamEnd;
            int nextNonWhitespace;
            this.visitNodeLists(parameters, null, null, punctuationType);
            if (lookForExtraComma && this.document.charAt(nextNonWhitespace = this.builder.getNextNonWhiteCharOffset(this.document, lastParamEnd = parameters.get(parameters.size() - 1).getEnd())) == ',') {
                this.pushTypePunctuation(punctuationType, nextNonWhitespace);
            }
        }
        if (pushParenthesisNode) {
            int closeParenStart = expressionEndOffset;
            int closeParenEnd = expressionEndOffset;
            if (!parenthesesNode.isAsWrapper()) {
                closeParenStart = PHPFormatterNodeBuilder.locateCharBackward(this.document, bracketsType.getRight().charAt(0), expressionEndOffset - 1, this.comments);
                closeParenEnd = closeParenStart + 1;
            }
            if (this.hasSingleLineCommentBefore(closeParenStart)) {
                parenthesesNode.setNewLineBeforeClosing(true);
                this.builder.checkedPop((IFormatterContainerNode)parenthesesNode, closeParenStart);
            } else if (this.hasMultiLineCommentBefore(closeParenStart)) {
                this.builder.checkedPop((IFormatterContainerNode)parenthesesNode, closeParenStart);
            } else {
                this.builder.checkedPop((IFormatterContainerNode)parenthesesNode, -1);
            }
            parenthesesNode.setEnd(AbstractFormatterNodeBuilder.createTextNode((IFormatterDocument)this.document, (int)closeParenStart, (int)closeParenEnd));
        }
    }

    private void pushNodeInParentheses(char openChar, char closeChar, int declarationEndOffset, int expressionEndOffset, ASTNode node, NodeTypes.TypeBracket type) {
        int openParen = PHPFormatterNodeBuilder.locateCharForward(this.document, openChar, declarationEndOffset, this.comments);
        int closeParen = PHPFormatterNodeBuilder.locateCharBackward(this.document, closeChar, expressionEndOffset, this.comments);
        FormatterPHPParenthesesNode parenthesesNode = new FormatterPHPParenthesesNode((IFormatterDocument)this.document, type);
        parenthesesNode.setBegin(AbstractFormatterNodeBuilder.createTextNode((IFormatterDocument)this.document, (int)openParen, (int)(openParen + 1)));
        this.builder.push((IFormatterContainerNode)parenthesesNode);
        if (node != null) {
            node.accept((Visitor)this);
        }
        this.builder.checkedPop((IFormatterContainerNode)parenthesesNode, -1);
        parenthesesNode.setEnd(AbstractFormatterNodeBuilder.createTextNode((IFormatterDocument)this.document, (int)closeParen, (int)(closeParen + 1)));
    }

    private void visitModifiers(int startOffset, int endOffset) {
        String modifiers = this.document.get(startOffset, endOffset);
        Matcher matcher = WORD_PATTERN.matcher(modifiers);
        boolean isFirst = true;
        while (matcher.find()) {
            FormatterPHPKeywordNode modifierNode = new FormatterPHPKeywordNode((IFormatterDocument)this.document, isFirst, false);
            modifierNode.setBegin(AbstractFormatterNodeBuilder.createTextNode((IFormatterDocument)this.document, (int)(matcher.start() + startOffset), (int)(matcher.end() + startOffset)));
            this.builder.push((IFormatterContainerNode)modifierNode);
            this.builder.checkedPop((IFormatterContainerNode)modifierNode, -1);
            isFirst = false;
        }
        if (isFirst) {
            FormatterPHPKeywordNode emptyModifier = new FormatterPHPKeywordNode((IFormatterDocument)this.document, isFirst, false);
            emptyModifier.setBegin(AbstractFormatterNodeBuilder.createTextNode((IFormatterDocument)this.document, (int)startOffset, (int)startOffset));
            this.builder.push((IFormatterContainerNode)emptyModifier);
            this.builder.checkedPop((IFormatterContainerNode)emptyModifier, -1);
        }
    }

    private void visitCommonLoopBlock(ASTNode node, int declarationEndOffset, Statement body, ASTNode condition) {
        this.visitCommonDeclaration(node, declarationEndOffset, true);
        if (condition != null) {
            int conditionEnd = body != null ? body.getStart() : node.getEnd();
            this.pushNodeInParentheses('(', ')', declarationEndOffset, conditionEnd, condition, NodeTypes.TypeBracket.LOOP_PARENTHESIS);
        }
        this.commonVisitBlockBody(node, (ASTNode)body);
    }

    private void commonVisitBlockBody(ASTNode parent, ASTNode body) {
        boolean emptyBody;
        boolean hasBlockedBody = body != null && body.getType() == 6;
        boolean bl = emptyBody = body != null && body.getType() == 22;
        if (hasBlockedBody) {
            this.visitBlockNode((Block)body, parent, true);
        } else if (body != null) {
            if (!emptyBody) {
                this.wrapInImplicitBlock(body, true);
            } else {
                body.accept((Visitor)this);
            }
        }
    }

    private void visitTextNode(ASTNode node, boolean consumePreviousWhitespaces, int spacesCountBefore) {
        this.visitTextNode(node.getStart(), node.getEnd(), consumePreviousWhitespaces, spacesCountBefore);
    }

    private void visitTextNode(int startOffset, int endOffset, boolean consumePreviousWhitespaces, int spacesCountBefore) {
        this.visitTextNode(startOffset, endOffset, consumePreviousWhitespaces, spacesCountBefore, 0);
    }

    private void visitTextNode(int startOffset, int endOffset, boolean consumePreviousWhitespaces, int spacesCountBefore, int spacesCountAfter) {
        FormatterPHPTextNode textNode = new FormatterPHPTextNode((IFormatterDocument)this.document, consumePreviousWhitespaces, spacesCountBefore, spacesCountAfter);
        textNode.setBegin(AbstractFormatterNodeBuilder.createTextNode((IFormatterDocument)this.document, (int)startOffset, (int)endOffset));
        this.builder.push((IFormatterContainerNode)textNode);
        this.builder.checkedPop((IFormatterContainerNode)textNode, endOffset);
    }

    private void visitBlockNode(Block block, ASTNode parent, boolean consumeEndingSemicolon) {
        String alternativeSyntaxCloser;
        int alternativeCloserLength;
        int end;
        boolean isAlternativeSyntaxBlock = !block.isCurly();
        FormatterPHPBlockNode blockNode = new FormatterPHPBlockNode((IFormatterDocument)this.document, this.hasAnyCommentBefore(block.getStart()));
        blockNode.setBegin(AbstractFormatterNodeBuilder.createTextNode((IFormatterDocument)this.document, (int)block.getStart(), (int)(block.getStart() + 1)));
        this.builder.push((IFormatterContainerNode)blockNode);
        block.childrenAccept((Visitor)this);
        int closingStartOffset = end = block.getEnd();
        if (!isAlternativeSyntaxBlock) {
            --closingStartOffset;
        }
        if (isAlternativeSyntaxBlock && closingStartOffset - (alternativeCloserLength = (alternativeSyntaxCloser = this.getAlternativeSyntaxCloser(parent)).length()) >= 0 && this.document.get(closingStartOffset - alternativeCloserLength, closingStartOffset).toLowerCase().equals(alternativeSyntaxCloser)) {
            closingStartOffset -= alternativeCloserLength;
        }
        this.builder.checkedPop((IFormatterContainerNode)blockNode, Math.min(closingStartOffset, end));
        blockNode.setEnd(AbstractFormatterNodeBuilder.createTextNode((IFormatterDocument)this.document, (int)closingStartOffset, (int)Math.max(closingStartOffset, end)));
    }

    private void visitFunctionDeclaration(ASTNode functionDeclaration, Identifier functionName, List<FormalParameter> formalParameters, List<Expression> lexicalParameters, Block body) {
        int parametersEnd;
        int declarationEnd = functionDeclaration.getStart() + 8;
        this.visitCommonDeclaration(functionDeclaration, declarationEnd, true);
        if (functionName != null) {
            this.visitTextNode((ASTNode)functionName, true, 1);
            declarationEnd = functionName.getEnd();
        }
        boolean hasLexicalParams = lexicalParameters != null && !lexicalParameters.isEmpty();
        int n = parametersEnd = body != null ? body.getStart() : functionDeclaration.getEnd();
        if (hasLexicalParams) {
            int firstLexicalOffset = lexicalParameters.get(0).getStart();
            parametersEnd = PHPFormatterNodeBuilder.locateCharBackward(this.document, 'u', firstLexicalOffset, this.comments) - 1;
        }
        this.pushParametersInParentheses(declarationEnd, parametersEnd, formalParameters, NodeTypes.TypePunctuation.COMMA, false, NodeTypes.TypeBracket.DECLARATION_PARENTHESIS, false);
        if (hasLexicalParams) {
            int useKeywordStart = this.builder.getNextNonWhiteCharOffset(this.document, this.builder.peek().getEndOffset());
            this.pushKeyword(useKeywordStart, 3, false, false);
            this.pushParametersInParentheses(useKeywordStart + 3, body.getStart(), lexicalParameters, NodeTypes.TypePunctuation.COMMA, false, NodeTypes.TypeBracket.DECLARATION_PARENTHESIS, false);
        }
        if (body != null) {
            FormatterPHPFunctionBodyNode bodyNode = new FormatterPHPFunctionBodyNode((IFormatterDocument)this.document, this.hasAnyCommentBefore(body.getStart()));
            bodyNode.setBegin(AbstractFormatterNodeBuilder.createTextNode((IFormatterDocument)this.document, (int)body.getStart(), (int)(body.getStart() + 1)));
            this.builder.push((IFormatterContainerNode)bodyNode);
            body.childrenAccept((Visitor)this);
            int bodyEnd = body.getEnd();
            this.builder.checkedPop((IFormatterContainerNode)bodyNode, bodyEnd - 1);
            bodyNode.setEnd(AbstractFormatterNodeBuilder.createTextNode((IFormatterDocument)this.document, (int)(bodyEnd - 1), (int)bodyEnd));
        }
    }

    private void visitCommonDeclaration(ASTNode node, int declarationEndOffset, boolean hasBlockedBody) {
        FormatterPHPDeclarationNode declarationNode = new FormatterPHPDeclarationNode((IFormatterDocument)this.document, hasBlockedBody, node);
        declarationNode.setBegin(AbstractFormatterNodeBuilder.createTextNode((IFormatterDocument)this.document, (int)node.getStart(), (int)declarationEndOffset));
        this.builder.push((IFormatterContainerNode)declarationNode);
        this.builder.checkedPop((IFormatterContainerNode)declarationNode, -1);
    }

    private void visitLeftRightExpression(ASTNode parentNode, ASTNode left, ASTNode right, String operatorString) {
        int leftOffset;
        if (left != null) {
            left.accept((Visitor)this);
            leftOffset = left.getEnd();
        } else {
            leftOffset = parentNode.getStart();
        }
        int rightOffset = right != null ? right.getStart() : parentNode.getEnd();
        int operatorOffset = this.document.get(leftOffset, rightOffset).indexOf(operatorString) + leftOffset;
        NodeTypes.TypeOperator typeOperator = NodeTypes.TypeOperator.getTypeOperator((String)operatorString.toLowerCase());
        this.pushTypeOperator(typeOperator, operatorOffset, false);
        if (right != null) {
            right.accept((Visitor)this);
        }
    }

    private void pushTypeOperator(NodeTypes.TypeOperator operator, int startOffset, boolean isUnary) {
        FormatterPHPOperatorNode node = new FormatterPHPOperatorNode((IFormatterDocument)this.document, operator, isUnary);
        node.setBegin(AbstractFormatterNodeBuilder.createTextNode((IFormatterDocument)this.document, (int)startOffset, (int)(startOffset + operator.toString().length())));
        this.builder.push((IFormatterContainerNode)node);
        this.builder.checkedPop((IFormatterContainerNode)node, -1);
    }

    private void pushTypePunctuation(NodeTypes.TypePunctuation punctuation, int startOffset) {
        FormatterPHPPunctuationNode node = new FormatterPHPPunctuationNode((IFormatterDocument)this.document, punctuation);
        node.setBegin(AbstractFormatterNodeBuilder.createTextNode((IFormatterDocument)this.document, (int)startOffset, (int)(startOffset + punctuation.toString().length())));
        this.builder.push((IFormatterContainerNode)node);
        this.builder.checkedPop((IFormatterContainerNode)node, -1);
    }

    private String getAlternativeSyntaxCloser(ASTNode parent) {
        switch (parent.getType()) {
            case 34: {
                return "endif";
            }
            case 61: {
                return "endwhile";
            }
            case 26: {
                return "endforeach";
            }
            case 28: {
                return "endfor";
            }
            case 56: {
                return "endswitch";
            }
        }
        return "";
    }

    private void pushKeyword(int start, int keywordLength, boolean isFirstInLine, boolean isLastInLine) {
        this.pushKeyword(start, keywordLength, isFirstInLine, isLastInLine, false);
    }

    private void pushKeyword(int start, int keywordLength, boolean isFirstInLine, boolean isLastInLine, boolean consumeSpaces) {
        FormatterPHPKeywordNode keywordNode = new FormatterPHPKeywordNode((IFormatterDocument)this.document, isFirstInLine, isLastInLine, consumeSpaces);
        keywordNode.setBegin(AbstractFormatterNodeBuilder.createTextNode((IFormatterDocument)this.document, (int)start, (int)(start + keywordLength)));
        this.builder.push((IFormatterContainerNode)keywordNode);
        this.builder.checkedPop((IFormatterContainerNode)keywordNode, -1);
    }

    private void findAndPushPunctuationNode(NodeTypes.TypePunctuation type, int offsetToSearch, boolean ignoreNonWhitespace, boolean isLineTerminating) {
        char punctuationType = type.toString().charAt(0);
        int punctuationOffset = PHPFormatterNodeBuilder.locateCharForward(this.document, punctuationType, offsetToSearch, this.comments);
        if (punctuationOffset != offsetToSearch || this.document.charAt(punctuationOffset) == punctuationType) {
            if (offsetToSearch + 1 < punctuationOffset) {
                String segment = this.document.get(offsetToSearch, punctuationOffset);
                if (!ignoreNonWhitespace && segment.trim().length() > 0) {
                    return;
                }
            }
            if (isLineTerminating) {
                int lineEnd = this.locateWhitespaceLineEndingOffset(punctuationOffset + 1);
                isLineTerminating = lineEnd < 0;
            }
            FormatterPHPPunctuationNode punctuationNode = new FormatterPHPPunctuationNode((IFormatterDocument)this.document, type, isLineTerminating);
            punctuationNode.setBegin(AbstractFormatterNodeBuilder.createTextNode((IFormatterDocument)this.document, (int)punctuationOffset, (int)(punctuationOffset + 1)));
            this.builder.push((IFormatterContainerNode)punctuationNode);
            this.builder.checkedPop((IFormatterContainerNode)punctuationNode, -1);
        }
    }

    private void wrapInImplicitBlock(ASTNode node, boolean indent) {
        FormatterPHPImplicitBlockNode emptyBlock = new FormatterPHPImplicitBlockNode((IFormatterDocument)this.document, false, indent, 0);
        int start = node.getStart();
        int end = node.getEnd();
        emptyBlock.setBegin(AbstractFormatterNodeBuilder.createTextNode((IFormatterDocument)this.document, (int)start, (int)start));
        this.builder.push((IFormatterContainerNode)emptyBlock);
        node.accept((Visitor)this);
        this.builder.checkedPop((IFormatterContainerNode)emptyBlock, -1);
        emptyBlock.setEnd(AbstractFormatterNodeBuilder.createTextNode((IFormatterDocument)this.document, (int)end, (int)end));
    }

    private int locateWhitespaceLineEndingOffset(int start) {
        int length = this.document.getLength();
        int offset = start;
        while (offset < length) {
            char c = this.document.charAt(offset);
            if (c == '\n' || c == '\r') {
                return offset;
            }
            if (!Character.isWhitespace(c)) {
                return -1;
            }
            ++offset;
        }
        return -1;
    }

    private int locateCharMatchInLine(int offset, char[] chars, FormatterDocument document, boolean ignoreNonWhitespace) {
        int i = offset;
        int size = document.getLength();
        while (i < size) {
            char c = document.charAt(i);
            char[] cArray = chars;
            int n = chars.length;
            int n2 = 0;
            while (n2 < n) {
                char toMatch = cArray[n2];
                if (c == toMatch) {
                    return i + 1;
                }
                ++n2;
            }
            if (c == '\n' || c == '\r' || !ignoreNonWhitespace && (c != ' ' || c != '\t')) break;
            ++i;
        }
        return offset;
    }

    private static boolean isWrappedInMatchingBrackets(NodeTypes.TypeBracket bracketsType, int startOffset, int endOffset, FormatterDocument document) {
        if (document.charAt(endOffset = Math.min(endOffset, document.getLength() - 1)) == ';') {
            --endOffset;
        }
        char openChar = bracketsType.getLeft().charAt(0);
        char closeChar = bracketsType.getRight().charAt(0);
        Stack<Character> brackets = new Stack<Character>();
        while (startOffset <= endOffset) {
            char c = document.charAt(startOffset);
            if (c == openChar) {
                brackets.push(Character.valueOf(c));
            } else if (c == closeChar ? brackets.isEmpty() || ((Character)brackets.pop()).charValue() != openChar : !Character.isWhitespace(c) && brackets.isEmpty()) {
                return false;
            }
            ++startOffset;
        }
        return brackets.isEmpty();
    }
}

